/*
 * Decompiled with CFR 0.152.
 */
package ru.daturum.cik;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.daturum.cik.CommandLineParser;
import ru.daturum.cik.ErrorOutput;
import ru.daturum.cik.SqlQueryReader;
import ru.daturum.cik.models.Election;
import ru.daturum.cik.models.Member;
import ru.daturum.cik.models.Uik;

public class DataMapper {
    private static final int DB_VERSION_2020 = 2020;
    private static final int DB_VERSION_2021 = 2021;
    private CommandLineParser cmdParser;
    private Connection connection;
    private SqlQueryReader sqlQueryReader;
    private int dbVersion;
    private static final String QUERY_FETCH_UIK_INFO = "fetch_uik_info";
    private static final String QUERY_FETCH_UIK_ELECTIONS_INFO = "fetch_uik_elections_info";
    private static final String QUERY_FETCH_UIK_ELECTIONS_INFO_2021 = "fetch_uik_elections_info_2021";
    private static final String QUERY_FETCH_MEMBERS_INFO = "fetch_uik_members_info";
    private static final String QUERY_FETCH_CUSTOM_MEMBERS_INFO = "fetch_uik_custom_members_info";
    private static final String QUERY_FETCH_CHECK_SCHEMA_2021 = "fetch_check_schema_2021";
    private static final String COL_UIK_BPG_UIK_ID = "UIK_ID";
    private static final String COL_UIK_BPG_UIK_NUM = "UIK_NUM";
    private static final String COL_UIK_BPG_UIK_NAME = "UIK_NAME";
    private static final String COL_UIK_BPG_UIK_POST_INDEX = "UIK_POST_INDEX";
    private static final String COL_UIK_BPG_UIK_PLACE = "UIK_PLACE";
    private static final String COL_UIK_BPG_UIK_STREET = "UIK_STREET";
    private static final String COL_UIK_BPG_UIK_HOUSE = "UIK_HOUSE";
    private static final String COL_UIK_BPG_CUSTOM_ADDRESS = "CUSTOM_ADDRESS";
    private static final String COL_UIK_BPG_CAMP_ID = "CAMP_ID";
    private static final String COL_UIK_BPG_CAMP_DT = "CAMP_DT";
    private static final String COL_UIK_BPG_CAMP_DT_S = "CAMP_DT_S";
    private static final String COL_UIK_BPG_CAMP_DT_E = "CAMP_DT_E";
    private static final String COL_UIK_BPG_CAMP_NAME = "CAMP_NAME";
    private static final String COL_UIK_BPG_CAMP_LEVEL = "CAMP_LEVEL";
    private static final String COL_UIK_BPG_VID_VIB = "VID_VIB";
    private static final String COL_UIK_BPG_SCHEME = "SCHEME";
    private static final String COL_UIK_MEMBER_LAST_NAME = "LAST_NAME";
    private static final String COL_UIK_MEMBER_FIRST_NAME = "FIRST_NAME";
    private static final String COL_UIK_MEMBER_PATRONYMIC = "PATRONYMIC";
    private static final String COL_UIK_MEMBER_POSITION_NAME = "POSITION_NAME";
    private static final String COL_UIK_MEMBER_EMPLOYEE_ID = "EMPLOYEE_ID";
    private static final String COL_UIK_MEMBER_POSITION_ID = "POSITION_ID";
    private static final String COL_UIK_MEMBER_PR_POLN_NO = "PR_POLN_NO";
    private static final String COL_UIK_CUSTOM_MEMBER_LAST_NAME = "LAST_NAME";
    private static final String COL_UIK_CUSTOM_MEMBER_FIRST_NAME = "FIRST_NAME";
    private static final String COL_UIK_CUSTOM_MEMBER_PATRONYMIC = "PATRONYMIC";
    private static final String COL_UIK_CUSTOM_MEMBER_POSITION_NAME = "POSITION_NAME_CUSTOM";
    private static final String COL_UIK_CUSTOM_MEMBER_EMPLOYEE_ID = "EMPLOYEE_ID";
    private static final String COL_UIK_CUSTOM_MEMBER_POSITION_ID = "POSITION_ID";
    private static final String COL_UIK_CUSTOM_MEMBER_PR_POLN_NO = "PR_POLN_NO";
    private static final String COL_UIK_CUSTOM_MEMBER_MODIFY_DT = "MODIFY_DT";
    private static final String COL_UIK_CUSTOM_MEMBER_LAST_VALUE = "LAST_VALUE";
    private static final String COL_CHECK_SCHEMA_2021_EXISTS_UIK_BPG_CAMP_DT_S = "EXISTS_UIK_BPG_CAMP_DT_S";
    private static final String COL_CHECK_SCHEMA_2021_EXISTS_UIK_BPG_CAMP_DT_E = "EXISTS_UIK_BPG_CAMP_DT_E";
    private static final String COL_UIK_CUSTOM_ADDRESS_ADDRESS = "ADDRESS";

    public DataMapper(CommandLineParser cmdParser) {
        this.cmdParser = cmdParser;
        this.connection = null;
        this.sqlQueryReader = new SqlQueryReader();
        this.dbVersion = -1;
    }

    public int getDbVersion() {
        if (this.dbVersion != -1) {
            return this.dbVersion;
        }
        this.dbVersion = this.detectDbVersion();
        return this.dbVersion;
    }

    public boolean isDbVersion2020() {
        return this.getDbVersion() == 2020;
    }

    public boolean isDbVersion2021() {
        return this.getDbVersion() == 2021;
    }

    public Uik fetchUikInfo(Integer uikNumber) {
        Connection conn = this.getConnection();
        try {
            PreparedStatement statement = conn.prepareStatement(this.getQuery(QUERY_FETCH_UIK_INFO));
            statement.setInt(1, uikNumber);
            statement.setInt(2, uikNumber);
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                Uik uik = new Uik();
                uik.setInternalId(result.getInt(COL_UIK_BPG_UIK_ID));
                uik.setNumber(result.getInt(COL_UIK_BPG_UIK_NUM));
                uik.setName(result.getString(COL_UIK_BPG_UIK_NAME));
                uik.setPostIndex(result.getString(COL_UIK_BPG_UIK_POST_INDEX));
                uik.setPlace(result.getString(COL_UIK_BPG_UIK_PLACE));
                uik.setStreet(result.getString(COL_UIK_BPG_UIK_STREET));
                uik.setHouse(result.getString(COL_UIK_BPG_UIK_HOUSE));
                uik.setCustomAddress(result.getString(COL_UIK_BPG_CUSTOM_ADDRESS));
                return uik;
            }
            return null;
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
            return null;
        }
    }

    public List<Election> fetchUikElections(Integer uikNumber) {
        Connection conn = this.getConnection();
        try {
            String query = this.getQuery(QUERY_FETCH_UIK_ELECTIONS_INFO);
            if (this.isDbVersion2021()) {
                query = this.getQuery(QUERY_FETCH_UIK_ELECTIONS_INFO_2021);
            }
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setInt(1, uikNumber);
            ArrayList<Election> elections = new ArrayList<Election>();
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                Election election = new Election();
                election.setInternalId(result.getInt(COL_UIK_BPG_CAMP_ID));
                election.setName(result.getString(COL_UIK_BPG_CAMP_NAME));
                election.setDate(result.getDate(COL_UIK_BPG_CAMP_DT));
                if (this.isDbVersion2021()) {
                    election.setDateStart(result.getDate(COL_UIK_BPG_CAMP_DT_S));
                    election.setDateEnd(result.getDate(COL_UIK_BPG_CAMP_DT_E));
                }
                election.setLevel(result.getInt(COL_UIK_BPG_CAMP_LEVEL));
                election.setVidVib(result.getInt(COL_UIK_BPG_VID_VIB));
                election.setScheme(result.getInt(COL_UIK_BPG_SCHEME));
                elections.add(election);
            }
            return elections;
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
            return null;
        }
    }

    public List<Member> fetchUikMembers(Integer uikNumber) {
        Connection conn = this.getConnection();
        try {
            PreparedStatement statement = conn.prepareStatement(this.getQuery(QUERY_FETCH_MEMBERS_INFO));
            statement.setInt(1, uikNumber);
            ArrayList<Member> elections = new ArrayList<Member>();
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                Member member = new Member();
                member.setLastName(result.getString("LAST_NAME"));
                member.setFirstName(result.getString("FIRST_NAME"));
                member.setMiddleName(result.getString("PATRONYMIC"));
                member.setPositionName(result.getString(COL_UIK_MEMBER_POSITION_NAME));
                member.setInternalId(result.getInt("EMPLOYEE_ID"));
                member.setPrPolnNo(result.getBoolean("PR_POLN_NO"));
                member.setCustom(false);
                member.setCurrent(true);
                member.setChangedAt(null);
                elections.add(member);
            }
            return elections;
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
            return null;
        }
    }

    public List<Member> fetchUikCustomMembers(Integer uikNumber) {
        Connection conn = this.getConnection();
        try {
            PreparedStatement statement = conn.prepareStatement(this.getQuery(QUERY_FETCH_CUSTOM_MEMBERS_INFO));
            statement.setInt(1, uikNumber);
            ArrayList<Member> elections = new ArrayList<Member>();
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                Member member = new Member();
                member.setLastName(result.getString("LAST_NAME"));
                member.setFirstName(result.getString("FIRST_NAME"));
                member.setMiddleName(result.getString("PATRONYMIC"));
                member.setPositionName(result.getString(COL_UIK_CUSTOM_MEMBER_POSITION_NAME));
                member.setInternalId(result.getInt("EMPLOYEE_ID"));
                member.setPrPolnNo(result.getBoolean("PR_POLN_NO"));
                member.setCustom(true);
                member.setCurrent(result.getBoolean(COL_UIK_CUSTOM_MEMBER_LAST_VALUE));
                member.setChangedAt(result.getTimestamp(COL_UIK_CUSTOM_MEMBER_MODIFY_DT));
                elections.add(member);
            }
            return elections;
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public List<Member> fetchUikCurrentMembers(Integer uikNumber) {
        List<Member> members = this.fetchUikCustomMembers(uikNumber);
        if (members.isEmpty()) {
            members = this.fetchUikMembers(uikNumber);
        }
        return members;
    }

    private Connection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        try {
            this.connection = DriverManager.getConnection(this.getConnectionString(), "sa", "");
        }
        catch (SQLException throwables) {
            if (throwables.getErrorCode() == 90020) {
                ErrorOutput.printErrorDbAlreadyOpened();
            }
            throwables.printStackTrace();
        }
        return this.connection;
    }

    private String getConnectionString() {
        return String.format("jdbc:h2:%1$s", this.escapeDbPath());
    }

    private String escapeDbPath() {
        return this.cmdParser.getDbPath().replaceAll("\\.mv\\.db$", "");
    }

    private String getQuery(String key) {
        return this.sqlQueryReader.getQuery(key);
    }

    private int detectDbVersion() {
        Connection conn = this.getConnection();
        try {
            PreparedStatement statement = conn.prepareStatement(this.getQuery(QUERY_FETCH_CHECK_SCHEMA_2021));
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                boolean existsUikBpgCampDtS = result.getBoolean(COL_CHECK_SCHEMA_2021_EXISTS_UIK_BPG_CAMP_DT_S);
                boolean existsUikBpgCampDtE = result.getBoolean(COL_CHECK_SCHEMA_2021_EXISTS_UIK_BPG_CAMP_DT_E);
                if (existsUikBpgCampDtS && existsUikBpgCampDtE) {
                    return 2021;
                }
                return 2020;
            }
            return 2020;
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
            return 2020;
        }
    }
}

