/*
 * Decompiled with CFR 0.152.
 */
package ru.daturum.cik;

import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.daturum.cik.CommandLineParser;
import ru.daturum.cik.executers.FetchAllData;
import ru.daturum.cik.executers.FetchElectionsData;
import ru.daturum.cik.executers.FetchUikData;
import ru.daturum.cik.executers.FetchUikMembersData;

public class Extractor {
    private static final Pattern COMMAND_FETCH_UIK_DATA = Pattern.compile("Fetch uik data:\\s*(?<uikNumber>\\d+)", 2);
    private static final Pattern COMMAND_FETCH_UIK_ELECTIONS_DATA = Pattern.compile("Fetch uik elections data:\\s*(?<uikNumber>\\d+)", 2);
    private static final Pattern COMMAND_FETCH_UIK_MEMBERS_DATA = Pattern.compile("Fetch uik members data:\\s*(?<uikNumber>\\d+)", 2);
    private static final Pattern COMMAND_FETCH_UIK_ALL_DATA = Pattern.compile("Fetch uik all data:\\s*(?<uikNumber>\\d+)", 2);
    private static final Pattern[] COMMANDS = new Pattern[]{COMMAND_FETCH_UIK_DATA, COMMAND_FETCH_UIK_ELECTIONS_DATA, COMMAND_FETCH_UIK_MEMBERS_DATA, COMMAND_FETCH_UIK_ALL_DATA};
    private CommandLineParser cmdParser;

    public Extractor(CommandLineParser cmdParser) {
        this.cmdParser = cmdParser;
    }

    public void run() {
        Scanner scanner = new Scanner(System.in);
        try {
            while (true) {
                System.out.println("Please input a line");
                String line = scanner.nextLine();
                System.out.printf("User input was: %s.%n", line);
                this.execCommand(line);
            }
        }
        catch (IllegalStateException | NoSuchElementException e) {
            System.out.println("System.in was closed; exiting");
            return;
        }
    }

    public void execCommand(String commandStr) {
        for (int i = 0; i < COMMANDS.length; ++i) {
            Pattern command = COMMANDS[i];
            Matcher matcher = command.matcher(commandStr);
            if (!matcher.find()) continue;
            this.execCommand(commandStr, command, matcher);
            break;
        }
    }

    public void execCommand(String commandStr, Pattern command, Matcher matcher) {
        if (command == COMMAND_FETCH_UIK_DATA) {
            this.execCommandFetchUikData(commandStr, command, matcher);
        } else if (command == COMMAND_FETCH_UIK_ELECTIONS_DATA) {
            this.execCommandFetchUikElectionsData(commandStr, command, matcher);
        } else if (command == COMMAND_FETCH_UIK_MEMBERS_DATA) {
            this.execCommandFetchUikMembersData(commandStr, command, matcher);
        } else if (command == COMMAND_FETCH_UIK_ALL_DATA) {
            this.execCommandFetchUikAllData(commandStr, command, matcher);
        }
    }

    public void execCommandFetchUikData(String commandStr, Pattern command, Matcher matcher) {
        Integer uikNumber = Integer.valueOf(matcher.group("uikNumber"));
        FetchUikData e = new FetchUikData(uikNumber, this.cmdParser);
        e.exec();
    }

    public void execCommandFetchUikElectionsData(String commandStr, Pattern command, Matcher matcher) {
        Integer uikNumber = Integer.valueOf(matcher.group("uikNumber"));
        FetchElectionsData e = new FetchElectionsData(uikNumber, this.cmdParser);
        e.exec();
    }

    public void execCommandFetchUikMembersData(String commandStr, Pattern command, Matcher matcher) {
        Integer uikNumber = Integer.valueOf(matcher.group("uikNumber"));
        FetchUikMembersData e = new FetchUikMembersData(uikNumber, this.cmdParser);
        e.exec();
    }

    public void execCommandFetchUikAllData(String commandStr, Pattern command, Matcher matcher) {
        Integer uikNumber = Integer.valueOf(matcher.group("uikNumber"));
        FetchAllData e = new FetchAllData(uikNumber, this.cmdParser);
        e.exec();
    }
}

