/*
 * Decompiled with CFR 0.152.
 */
package ru.daturum.cik.executers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.TimeZone;
import ru.daturum.cik.CommandLineParser;
import ru.daturum.cik.DataMapper;

public abstract class BaseUikData {
    private Integer uikNumber;
    private CommandLineParser cmdParser;

    public BaseUikData(Integer uikNumber, CommandLineParser cmdParser) {
        this.uikNumber = uikNumber;
        this.cmdParser = cmdParser;
    }

    public abstract void exec();

    public Integer getUikNumber() {
        return this.uikNumber;
    }

    public CommandLineParser getCmdParser() {
        return this.cmdParser;
    }

    protected DataMapper buildDataMapper() {
        return new DataMapper(this.cmdParser);
    }

    protected void writeJsonToStdout(Object object) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            objectMapper.setTimeZone(TimeZone.getDefault());
            String j = objectMapper.writeValueAsString(object);
            System.out.println(String.format("OUTPUT: %1$s", j));
            System.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

