/*
 * Decompiled with CFR 0.152.
 */
package ru.daturum.cik.executers;

import java.util.List;
import ru.daturum.cik.CommandLineParser;
import ru.daturum.cik.DataMapper;
import ru.daturum.cik.executers.BaseUikData;
import ru.daturum.cik.models.Election;
import ru.daturum.cik.models.Member;
import ru.daturum.cik.models.Uik;

public class FetchAllData
extends BaseUikData {
    public FetchAllData(Integer uikNumber, CommandLineParser cmdParser) {
        super(uikNumber, cmdParser);
    }

    @Override
    public void exec() {
        AllData allData = new AllData();
        DataMapper dataMapper = this.buildDataMapper();
        allData.setUik(dataMapper.fetchUikInfo(this.getUikNumber()));
        allData.setElections(dataMapper.fetchUikElections(this.getUikNumber()));
        allData.setMembers(dataMapper.fetchUikCurrentMembers(this.getUikNumber()));
        this.writeJsonToStdout(allData);
    }

    class AllData {
        private Uik uik;
        private List<Election> elections;
        private List<Member> members;

        AllData() {
        }

        public Uik getUik() {
            return this.uik;
        }

        public void setUik(Uik uik) {
            this.uik = uik;
        }

        public List<Election> getElections() {
            return this.elections;
        }

        public void setElections(List<Election> elections) {
            this.elections = elections;
        }

        public List<Member> getMembers() {
            return this.members;
        }

        public void setMembers(List<Member> members) {
            this.members = members;
        }
    }
}

