SELECT UIK_CUSTOM_MEMBER.*,
       (CASE WHEN UIK_CUSTOM_MEMBER.POSITION_NAME_FOR_PRINT IS NOT NULL AND TRIM(UIK_CUSTOM_MEMBER.POSITION_NAME_FOR_PRINT) <> ''
             THEN UIK_CUSTOM_MEMBER.POSITION_NAME_FOR_PRINT
             ELSE UIK_CUSTOM_MEMBER.POSITION_NAME
        END) AS POSITION_NAME_CUSTOM
FROM UIK_CUSTOM_MEMBER
  INNER JOIN (SELECT UIK_CUSTOM_MEMBER.UIK_ID, MAX(UIK_CUSTOM_MEMBER.MODIFY_DT) MAX_MODIFY_DT, UIK_CUSTOM_MEMBER.EMPLOYEE_ID
              FROM UIK_CUSTOM_MEMBER
              WHERE UIK_CUSTOM_MEMBER.LAST_VALUE = true
                AND UIK_CUSTOM_MEMBER.UIK_ID IN (SELECT UIK_ID FROM UIK_BPG WHERE UIK_NUM=? LIMIT 1)
              GROUP BY UIK_CUSTOM_MEMBER.UIK_ID, UIK_CUSTOM_MEMBER.EMPLOYEE_ID) t
    ON UIK_CUSTOM_MEMBER.UIK_ID = t.UIK_ID AND
       UIK_CUSTOM_MEMBER.MODIFY_DT = t.MAX_MODIFY_DT AND
       UIK_CUSTOM_MEMBER.EMPLOYEE_ID = t.EMPLOYEE_ID
WHERE LAST_VALUE = true AND
  LAST_NAME iS NOT NULL AND TRIM(LAST_NAME) != '' AND
  FIRST_NAME iS NOT NULL AND TRIM(FIRST_NAME) != '';
