select *,
      (CASE UIK_INFO.FULL_ADDRESS when UIK_INFO.CHANGED_CUSTOM_ADDRESS then NULL ELSE UIK_INFO.CHANGED_CUSTOM_ADDRESS END) AS CUSTOM_ADDRESS
FROM (SELECT UIK_BPG.*,
             concat_ws(', ', UIK_BPG.UIK_POST_INDEX, UIK_BPG.UIK_PLACE, UIK_BPG.UIK_STREET, UIK_BPG.UIK_HOUSE) AS FULL_ADDRESS,
             custom_address.ADDRESS AS CHANGED_CUSTOM_ADDRESS
      FROM UIK_BPG
        LEFT OUTER JOIN (SELECT UIK_CUSTOM_ADDRESS.*
                         FROM UIK_CUSTOM_ADDRESS
                           INNER JOIN (SELECT UIK_CUSTOM_ADDRESS.UIK_ID, MAX(UIK_CUSTOM_ADDRESS.MODIFY_DT) AS MAX_MODIFY_DT
                                       FROM UIK_CUSTOM_ADDRESS
                                       WHERE LAST_VALUE = true
                                            AND UIK_CUSTOM_ADDRESS.UIK_ID IN (SELECT UIK_ID FROM UIK_BPG WHERE UIK_NUM=? LIMIT 1)
                                       GROUP BY UIK_CUSTOM_ADDRESS.UIK_ID) t
                             ON UIK_CUSTOM_ADDRESS.UIK_ID = t.UIK_ID AND
                                UIK_CUSTOM_ADDRESS.MODIFY_DT = t.MAX_MODIFY_DT) custom_address
          ON UIK_BPG.UIK_ID = custom_address.UIK_ID
    WHERE UIK_NUM=?
    LIMIT 1) UIK_INFO;